#marker for appdeploy file
$INSTALL_HASH='## <Perform Installation tasks here>'
$UNINSTALL_HASH='## <Perform Pre-Uninstallation tasks here>'
$beforeLocation=''



function initialize{
  [CmdletBinding()]
  param(
    [Parameter(Mandatory=$true)]
    [string]$Site,
    [Parameter(Mandatory=$true)]
    [string]$Siteserver
  )
  #Load the ConfigurationManager Module
  
  #from http://www.dexterposh.com/2014/06/powershell-sccm-2012-getting-started.html
  try
  {
    $ConfigMgrModule = "$($env:SMS_ADMIN_UI_PATH | Split-Path -Parent)\ConfigurationManager.psd1"
    if (!(Test-Path $ConfigMgrModule)) {
      throw 'Configuration Manager module not found in admin console path'
    }
    write-host 'Loading ConfigMgr Module from ' $ConfigMgrModule
    Import-Module "$ConfigMgrModule"
    #Get-Module
    $BeforeLocation = (Get-Location).Path
  } catch 
  {
    Write-Error $_.Exception.Message        
  }
  
  Set-Location $site":"
}



function New-SoftwareCollection {
  [CmdletBinding()]
  param(
    [Parameter(Mandatory=$true)]
    [PSCustomObject]$appDefObject,
    [Parameter(Mandatory=$true)]
    [PSCustomObject]$globalDefObject
  )
  
  initialize -Site $globalDefObject.site -Siteserver $globalDefObject.Siteserver
  
  $PSDefaultParameterValues =@{
        'get-cimclass:namespace'='Root\SMS\site_'+$globalDefObject.site;
        'get-cimclass:computername'=$globalDefObject.siteserver;
        'get-cimInstance:computername'=$globalDefObject.siteserver;
        'get-ciminstance:namespace'='Root\SMS\site_'+$globalDefObject.site;
        'get-wmiobject:namespace'='Root\SMS\site_'+$globalDefObject.site;
        'get-WMIObject:computername'=$globalDefObject.siteserver}
  
  $rootDeviceFolder=Get-CimInstance -ClassName SMS_ObjectContainerNode -Filter 'ObjectType=5000 and ParentContainerNodeid=0'
  
  $folderpath=join-path $globalDefObject.rootFolder $appDefObject.vendor
  write-host ('new-SoftwareCollection: Joined Path: '+$folderpath)
  #create device collection folders=5000
  $targetFolder=new-FolderPath -folderPath $folderpath -parentID 0 -folderTyp 5000 -globalDefObject $globalDefObject
  #create application folders=6000
  $appFolder=new-FolderPath  -folderPath $appDefObject.vendor -parentID 0 -folderTyp 6000 -globalDefObject $globalDefObject
  
  
  $colName=$appDefObject.appShortName
  write-host ('New-SoftwareCollection: '+$colName)
  $collection=Get-CMDeviceCollection -name $colName
  if (-not $collection) {
    $collection=New-CMDeviceCollection -Name $colName -Comment ('Software Deployment Target for '+$appDefObject.software) -LimitingCollectionName $globalDefObject.limitingCollection  -RefreshType Periodic -RefreshSchedule (New-CMSchedule -Start (get-date) -RecurInterval Minutes -RecurCount $globalDefObject.updateCollectionMin) 
    write-host ("Collection $colName successfull created. ID:"+$collection.CollectionID)
    if ($globalDefObject.includeCollection -ne $null) {
      Add-CMDeviceCollectionIncludeMembershipRule -CollectionID $collection.CollectionID -IncludeCollectionName $globalDefObject.includeCollection
    }
  }
  else
  {
    write-verbose ("Collection $colName already exists. ID:"+$collection.CollectionID)
  }
  Move-CMObject -FolderPath ($globalDefObject.site+':\DeviceCollection\'+$folderpath) -InputObject $collection
  
  $collection=Get-CMDeviceCollection -name $colName
  $collection
  Set-Location $BeforeLocation
}


#device collection folder=5000, user collection=5001, Application folder=6000
function Get-Folder {
  param
  (
    [Parameter(Mandatory=$true)]
    [System.String]
    $name,
    [Parameter(Mandatory=$true)]
    [System.Int32]
    $parentID,
    [Parameter(Mandatory=$false)]
    [System.Int32]
    $folderTyp = 5000
  )
  
  Get-CimInstance -ClassName SMS_ObjectContainerNode -Filter "ObjectType=$folderTyp and ParentContainerNodeid=$parentID and Name='$name'"
}
 
 #device collection folder=5000, user collection=5001, Application folder=6000
 function New-Folder
{
  param
  (
    [Parameter(Mandatory=$true)]
    [System.String]
    $name,
    [Parameter(Mandatory=$true)]
    [System.Int32]
    $parentID,
    [Parameter(Mandatory=$false)]
    [System.Int32]
    $folderTyp = 5000,
    [Parameter(Mandatory=$true)]
    [System.Management.Automation.PSObject]
    $globalDefObject
  )
  
  $rt=get-folder $name $parentID $folderTyp
  if (-not $rt) {
    $rt=New-CimInstance -ClassName SMS_ObjectContainerNode -Property @{Name=$name;ObjectType=$folderTyp;ParentContainerNodeid=$parentID;SourceSite=$globalDefObject.site} -Namespace $globalDefObject.namespace -ComputerName $globalDefObject.siteserver 
    Write-Host "Folder $name successfull created."
  }
  else
  {
    write-verbose "Folder $name already exists."
  }
  $rt
}
   #device collection folder=5000, user collection=5001, Application folder=6000
 function New-FolderPath
{
  param
  (
    [Parameter(Mandatory=$true)]
    [System.String]
    $folderPath,
    [Parameter(Mandatory=$true)]
    [System.Int32]
    $parentID,
    [Parameter(Mandatory=$false)]
    [System.Int32]
    $folderTyp = 5000,
    [Parameter(Mandatory=$true)]
    [System.Management.Automation.PSObject]
    $globalDefObject
  )
  
  $folders=$folderPath.split('\')
  $parentID=0
  $folders | ForEach-Object {
    $folder=$_
    $rt=new-Folder -name $folder -parentID $parentID -folderTyp $folderTyp -globalDefObject $globalDefObject
    $parentID=$rt.ContainerNodeID
  }
  $rt
}

function New-CMApplicationDetect{
  [CmdletBinding()]
  param(
    [Parameter(Mandatory=$true)]
    [PSCustomObject]$appDefObject,
    [Parameter(Mandatory=$true)]
    [PSCustomObject]$globalDefObject
  )
  
  initialize -Site $globalDefObject.site -Siteserver $globalDefObject.siteserver
  
  $appName=$appDefObject.appLongName
  
  $app=Get-CMApplication -Name $appName
  if (-not $app) {
    $app=New-CMApplication -Name $appName -Description 'Created by automateAppDeployment from mbaeker.de' -SoftwareVersion $appDefObject.version -AutoInstall $true -Publisher $appDefObject.vendor
  }
  
  
  
  #    Parameter Set: AddDeploymentTypeByScriptInstallerManual (http://technet.microsoft.com/en-us/library/jj870953%28v=sc.20%29.aspx)
  #Add-CMDeploymentType -ApplicationName <String> -DeploymentTypeName <String> -DetectDeploymentTypeByCustomScript -InstallationProgram <String> -ManualSpecifyDeploymentType -ScriptContent <String> -ScriptInstaller -ScriptType <ScriptLanguage> [-AdministratorComment <String> ] [-AllowClientsToShareContentOnSameSubnet <Boolean> ] [-ContentLocation <String> ] [-EstimatedInstallationTimeMinutes <Int32> ] [-InstallationBehaviorType <InstallationBehaviorType> {InstallForSystem | InstallForSystemIfResourceIsDeviceOtherwiseInstallForUser | InstallForUser} ] [-InstallationProgramVisibility <UserInteractionMode> {Normal | Minimized | Maximized | Hidden} ] [-InstallationStartIn <String> ] [-Language <String[]> ] [-LogonRequirementType <LogonRequirementType> {OnlyWhenNoUserLoggedOn | OnlyWhenUserLoggedOn | WhereOrNotUserLoggedOn | WhetherOrNotUserLoggedOn} ] [-MaximumAllowedRunTimeMinutes <Int32> ] [-PersistContentInClientCache <Boolean> ] [-RequiresUserInteraction <Boolean> ] [-RunInstallationProgramAs32BitProcessOn64BitClient <Boolean> ] [-RunScriptAs32bitProcessOn64bitClient <Boolean> ] [-UninstallProgram <String> ] [-UninstallStartIn <String> ] [-Confirm] [-WhatIf] [ <CommonParameters>]
  
  $depName=('AppDeploy '+$appDefObject.vendor+' '+$appDefObject.software)  
  $dep=get-CMDeploymentType -ApplicationName $app.LocalizedDisplayName -DeploymentTypeName $depName
  if (-not $dep) {
    #source http://www.dexterposh.com/2014/04/powershell-sccm-2012-r2-deploy.html
    #write-host $script
    
    
    $DeploymentTypeHash = @{
                    ApplicationName = $appName #Application Name 
                    DeploymentTypeName = $depName   #Name given to the Deployment Type
                    ScriptInstaller = $true
                    ManualSpecifyDeploymentType=$true
                    DetectDeploymentTypeByCustomScript = $true # Yes deployment type will use a custom script to detect the presence of this 
                    ScriptType = 'Powershell'
                    ScriptContent = $appDefObject.detect
                    AdministratorComment = 'Created by automateAppDeployment from mbaeker.de'
                    ContentLocation = $appDefObject.uncTargetFiles
                    InstallationProgram ='deploy-application.exe'  #Command line to Run for install
                    UninstallProgram ='deploy-Application.EXE -DeploymentType "Uninstall"' #Command line to Run for un-Install
                    RequiresUserInteraction = $false  #Don't let User interact with this
                    InstallationBehaviorType = 'InstallForSystem' # Targeting Devices here
                    InstallationProgramVisibility = 'Normal'  # Hide the PowerShell Console
                    LogonRequirementType = 'WhereOrNotUserLoggedOn'
                    }
    
    if (-not $appDefObject.hasUninstall) {
      $DeploymentTypeHash.remove('UninstallProgram')
    }                                  
    
    Add-CMDeploymentType @DeploymentTypeHash 
  }
  else
  {
    write-host "Warning: DeploymentType $depName already exist..."
  }
  
  $app
  #cd $BeforeLocation
}
 
function Move-CMApp{
  [CmdletBinding()]
  param(
    [Parameter(Mandatory=$true)]
    [PSCustomObject]$appDefObject,
    [Parameter(Mandatory=$true)]
    [PSCustomObject]$globalDefObject
  ) 
  Move-CMObject -FolderPath ($globalDefObject.site+':\Application\'+$appDefObject.vendor) -ObjectId $appDefObject.applicationObjectID
}

function Start-CMDeployment{
  [CmdletBinding()]
  Param (
    [Parameter(Mandatory=$true)]
    [PSCustomObject]$appDefObject,
    [Parameter(Mandatory=$true)]
  [PSCustomObject]$globalDefObject)
  
  $colName=$appDefObject.appShortName
  $appName=$appDefObject.appLongName
  
  Start-CMContentDistribution -ApplicationName ($appName) -DistributionPointGroupName ($globalDefObject.DistributionPointGroupName)
  
  Start-CMApplicationDeployment -CollectionName ($colName) -Name ($appname) -DeployAction Install -DeployPurpose Available -UserNotification DisplayAll -AvaliableDate (get-date) -AvaliableTime (get-date) -TimeBaseOn LocalTime  
}


#region Function Get-MsiTableProperty
Function Get-MsiTableProperty {
<#
.SYNOPSIS
	Get all of the properties from an MSI table and return as a custom object.
.DESCRIPTION
	Use the Windows Installer object to read all of the properties from a MSI table.
.PARAMETER Path
	The fully qualified path to an MSI file.
.PARAMETER Table
	The name of the the MSI table from which all of the properties must be retrieved. Default is: 'Property'.
.PARAMETER ContinueOnError
	Continue if an error is encountered. Default is: $true.
.EXAMPLE
	Get-MsiTableProperty -Path 'C:\Package\AppDeploy.msi'
	Retrieve all of the properties from the default 'Property' table.
.EXAMPLE
	Get-MsiTableProperty -Path 'C:\Package\AppDeploy.msi' -Table 'Property' | Select-Object -ExpandProperty ProductCode
	Retrieve all of the properties from the 'Property' table and then pipe to Select-Object to select the ProductCode property.
.NOTES
	This is an internal script function and should typically not be called directly.
.LINK
	http://psappdeploytoolkit.codeplex.com
#>
  [CmdletBinding()]
  Param (
    [Parameter(Mandatory=$true)]
    [ValidateScript({ $_ | Test-Path -PathType Leaf })]
    [string]$Path,
    [Parameter(Mandatory=$false)]
    [ValidateNotNullOrEmpty()]
    [string]$Table = 'Property',
    [Parameter(Mandatory=$false)]
    [ValidateNotNullorEmpty()]
    [boolean]$ContinueOnError = $true
  )
  
  Begin {
    ## Get the name of this function and write header
    [string]${CmdletName} = $PSCmdlet.MyInvocation.MyCommand.Name
    #Write-FunctionHeaderOrFooter -CmdletName ${CmdletName} -CmdletBoundParameters $PSBoundParameters -Header
    
    [scriptblock]$InvokeMethod = {
      Param (
        [__comobject]$Object,
        [string]$MethodName,
        [object[]]$ArgumentList
      )
      Write-Output $Object.GetType().InvokeMember($MethodName, [System.Reflection.BindingFlags]::InvokeMethod, $null, $Object, $ArgumentList, $null, $null, $null)
    }
    
    [scriptblock]$GetProperty = {
      Param (
        [__comobject]$Object,
        [string]$PropertyName,
        [object[]]$ArgumentList
      )
      Write-Output $Object.GetType().InvokeMember($PropertyName, [System.Reflection.BindingFlags]::GetProperty, $null, $Object, $ArgumentList, $null, $null, $null)
    }
  }
  Process {
    Try {
      #Write-Log -Message "Get properties from MSI file [$Path] in table [$Table]" -Source ${CmdletName}
      
      ## Create an empty object to store properties in
      [psobject]$TableProperties = New-Object -TypeName PSObject
      ## Create a Windows Installer object
      [__comobject]$Installer = New-Object -ComObject WindowsInstaller.Installer -ErrorAction 'Stop'
      ## Open MSI database in read only mode
      [int32]$OpenMSIReadOnly = 0
      [__comobject]$Database = &$InvokeMethod -Object $Installer -MethodName 'OpenDatabase' -ArgumentList @($Path, $OpenMSIReadOnly)
      ## Open the "Property" table view
      [__comobject]$View = &$InvokeMethod -Object $Database -MethodName 'OpenView' -ArgumentList @("SELECT * FROM $Table")
      &$InvokeMethod -Object $View -MethodName 'Execute' | Out-Null
      
      ## Retrieve the first row from the "Properties" table
      [__comobject]$Record = &$InvokeMethod -Object $View -MethodName 'Fetch'
      ## If the first row was successfully retrieved, then save data and loop through the entire table
      While ($Record) {
        #  Add property and value to custom object
        $TableProperties | Add-Member -MemberType NoteProperty -Name (&$GetProperty -Object $Record -PropertyName 'StringData' -ArgumentList @(1)) -Value (&$GetProperty -Object $Record -PropertyName 'StringData' -ArgumentList @(2))
        #  Retrieve the next row in the table
        [__comobject]$Record = &$InvokeMethod -Object $View -MethodName 'Fetch'
      }
      
      Write-Output $TableProperties
    }
    Catch {
      #Write-Log -Message "Failed to get the MSI table [$Table]. `n" -Severity 3 -Source ${CmdletName}
      If (-not $ContinueOnError) {
        Throw "Failed to get the MSI table [$Table]: $($_.Exception.Message)"
      }
    }
    Finally {
      If ($View) {
        &$InvokeMethod -Object $View -MethodName 'Close' -ArgumentList @() | Out-Null
      }
    }
  }
  End {
    #Write-FunctionHeaderOrFooter -CmdletName ${CmdletName} -Footer
  }
}
#endregion

#source: http://stackoverflow.com/questions/15662799/powershell-function-to-replace-or-add-lines-in-text-files
function setConfig {
  param
  (
    [Parameter(Mandatory=$true)]
    [System.Object]
    $file,
    [Parameter(Mandatory=$true)]
    [System.Object]
    $key,
    [Parameter(Mandatory=$true)]
    [System.Object]
    $value
  )
  
  $content = Get-Content $file
  $search='^[\t\s]*'+[regex]::escape($key)+'\s*='
  if ( $content -match $search ) {
    $content=$content -replace "$search.*", "$key = $value" |  set-content $file -force 
  } else
  {
    write-host -ForegroundColor Yellow "Couldn't find and replace key $key in file $file"
  }
}


function replaceLine {
  param
  (   
    [Parameter(Mandatory=$true)]
    [System.Object]
    $file,
    [Parameter(Mandatory=$true)]
    [System.Object]
    $line,
    [Parameter(Mandatory=$true)]
    [System.Object]
    $newline
  )
  
  $content = Get-Content $file
  $search='^[\t\s]*'+[regex]::escape($line)
  
  #workaround, damit $_ im regex replace nicht aufgelst wird...
  if ( $content -match $search ) {
    $newContent='' 
    $content | ForEach-Object { 
      if ($_ -match $search) {
        $newContent+=$newLine+[Environment]::NewLine
      }
      else
      {
        $newContent+=$_+[Environment]::NewLine
      }
    }
    
    $newcontent | set-content -Path $file -Force
  } else
  {
    write-host -ForegroundColor Yellow "Couldn't find and replace line $line (search: $search) in file $file"
  }
}

function New-ApplicationSource {
  [CmdletBinding()]
  param(
    [Parameter(Mandatory=$true)]
    [PSCustomObject]$appDefObject,
    [Parameter(Mandatory=$true)]
    [PSCustomObject]$globalDefObject
  )
  $appName=$appDefObject.appShortName
  $targetPath=$appDefObject.targetFiles
  
  #create folder
  if (-not (Test-Path  ($targetpath)))
  {
    new-item -Path  ($targetpath) -ItemType Directory
  }
  
  Get-ChildItem -Path ($globalDefObject.appdeploySource) | ForEach-Object {
    # $_.FullName
    Copy-Item -Force -Path  ($_.FullName) -Recurse -Destination  ($targetPath)
  }
  
  #copy source files to files in destination
  $filesDir=Join-Path $targetPath 'Files'
  Get-ChildItem -Path $appDefObject.sourceFiles | ForEach-Object {
    Copy-Item -Force -Path ($_.FullName) -Recurse -Destination ($filesDir)
  }
  
  $deployAppFile=Join-Path $targetPath 'Deploy-Application.ps1'
  
  #setting base infos in Deploy-Application File
  setConfig $deployAppFile "[string]`$appVendor" ("`""+$appDefObject.vendor+"`"")
  setConfig $deployAppFile "[string]`$appName" ("`""+$appDefObject.software+"`"")
  setConfig $deployAppFile "[string]`$appVersion" ("`""+$appDefObject.version+"`"")
  setConfig $deployAppFile "[string]`$appScriptDate" ("`""+(get-date)+"`"")
  setConfig $deployAppFile "[string]`$appScriptAuthor" ("`""+[Environment]::UserDomainName+'\'+[Environment]::UserName+"`"")
  
  #install
  replaceline $deployAppFile "Show-InstallationWelcome -CloseApps 'iexplore' -AllowDefer -DeferTimes 3 -CheckDiskSpace -PersistPrompt" "#Show-InstallationWelcome -CloseApps 'iexplore' -AllowDefer -DeferTimes 3 -CheckDiskSpace -PersistPrompt"
  $installCommand=''
  
  if ($appdefObject.install -eq $null -or $appDefObject.install -eq '') {
    write-host 'new-AppDeployApplication: no install parameter. Trying to add MSI Files'
    #install  for msi files
    Get-ChildItem -Path $filesdir -Filter *.msi | ForEach-Object {
      addAppDeployMSI $deployAppFile $_.Name
    }
  }
  else
  {
    replaceline $deployAppFile $INSTALL_HASH ($appDefObject.install+[Environment]::NewLine+$INSTALL_HASH)
  }
  
  if ( $appDefObject.uninstall -eq $null -or $appDefObject.uninstall -eq '') {
    write-host 'new-AppDeployApplication: no unInstallString parameter. Trying to add MSI Files'
    #uninstall for msi files
    Get-ChildItem -Path $filesdir -Filter *.msi | ForEach-Object {
      addAppDeployUnMSI $deployAppFile $_.Name
    }
  }
  else
  {
    replaceline $deployAppFile $UNINSTALL_HASH ($appDefObject.uninstall+[Environment]::NewLine+$UNINSTALL_HASH)
  }
  
  replaceline $deployAppFile "Show-InstallationPrompt -Message 'You can customize text" ""
  
  #uninstall
  replaceline $deployAppFile "Show-InstallationWelcome -CloseApps 'iexplore' -CloseAppsCountdown 60" "#Show-InstallationWelcome -CloseApps 'iexplore' -CloseAppsCountdown 60"
}

function addAppDeployMSI {
  param
  (
    [Parameter(Mandatory=$true)]
    [System.String]
    $deployAppFile,
    [Parameter(Mandatory=$true)]
    [System.String]
    $msiFileName
  )
  
  $installCommand=[Environment]::NewLine+"Execute-MSI -Action Install -Path `""+$msiFileName+"`""
  replaceline $deployAppFile $INSTALL_HASH ($installCommand+[Environment]::NewLine+$INSTALL_HASH)
}

function addAppDeployUnMSI {
  param
  (
    [Parameter(Mandatory=$true)]
    [System.String]
    $deployAppFile,
    [Parameter(Mandatory=$true)]
    [System.String]
    $msiFileName
  )
  
  $installCommand=[Environment]::NewLine+"Execute-MSI -Action Uninstall -Path `""+$msiFileName+"`""
  replaceline $deployAppFile $UNINSTALL_HASH ($installCommand+[Environment]::NewLine+$UNINSTALL_HASH)
}




 export-modulemember *-*

