﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Configuration.Install;
using Microsoft.EnterpriseManagement;
using Microsoft.EnterpriseManagement.ConnectorFramework;
using Microsoft.EnterpriseManagement.Common;
using Microsoft.EnterpriseManagement.Monitoring;
using System.ServiceProcess;
using System.Collections.ObjectModel;
using System.Diagnostics;


namespace NagiosService
{
    /**
     * Step 4: Install the service

From the bin directory of the service application you generate, install the service using the installutil.exe command. Run the following commands from a Visual Studio .NET command prompt (Start->Programs->Visual Studio->Tools->Command Prompt) to ensure the installutil program is in your path.

To install a service: installutil servicename.exe

To uninstall: installutil /u servicename.exe

Note that you must either specify the full path of the service exe, or you have to be in the directory where the service resides, to run the installutil program. Go to the Windows management console (Right click on My Computer->Manage->Services and Applications->Services). To view the recovery options, right click on the service in the list, select Properties, and then select the Recovery tab.
     */
    [RunInstaller(true)]
    public partial class NagiosServiceInstaller : Installer
    {
        private ServiceInstaller serviceInstaller;
        private ServiceProcessInstaller processInstaller;
        public NagiosServiceInstaller()
        {
           // InitializeComponent();
            processInstaller = new ServiceProcessInstaller();
            serviceInstaller = new ServiceInstaller();

            // Service will be setup to run as local system. You will
            // probably need to change this (via service manager console) to something that has rights to
            // access Operations Manager.
            processInstaller.Account = ServiceAccount.LocalSystem;

            // Service will have Start Type of Automatic
            serviceInstaller.StartType = ServiceStartMode.Automatic;

            serviceInstaller.ServiceName = "NagiosConnector";
            serviceInstaller.Description = "KIT Nagios OpsMgr Connector";
            serviceInstaller.DisplayName = "KIT Nagios Connector";

            Installers.Add(serviceInstaller);
            Installers.Add(processInstaller);
        }

        public override void Install(IDictionary stateSaver)
        {
            base.Install(stateSaver);

        }

        public override void Uninstall(IDictionary savedState)
        {
            base.Uninstall(savedState);

            
        }
    }
}
