﻿using System.ServiceProcess;
using System;
using System.Security.Permissions;
using System.Diagnostics;
using System.Collections.Generic;
using System.Text;

namespace NagiosService
{
    /// <summary>
    /// Copyright (C) 2009 Markus Bäker
    /// This program is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; 
    /// either version 3 of the License, or (at your option) any later version.
    /// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; 
    /// without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.
    /// You should have received a copy of the GNU General Public License along with this program; if not, see <http://www.gnu.org/licenses/>.
    /// 
    /// </summary>
    [SecurityPermission(SecurityAction.Demand, Flags = SecurityPermissionFlag.ControlAppDomain)]
    public class Program
    {
        static EventLog appLog = null;
        /// <summary>
        /// Einstiegspunkt zum Installieren des Dienstes und zur
        /// Deinstallation
        /// </summary>
        public static void Main(String[] args)
        {
            SCOMAdapter scom = new SCOMAdapter();
            scom.openConnection();
            if (args.Length == 1)
            {
                if (args[0] == "InstallConnector")
                {
                    scom.installConnector();
                    Console.WriteLine("Connector installed.");
                    return;
                }
                else if (args[0] == "UninstallConnector")
                {
                    scom.uninstallConnector();
                    return;
                }
            }

            /// unhandled Exceptions werden die die logUnhand.. Methode weitergereicht (ermöglicht auch logging im fehlerfall)
            AppDomain currentDomain = AppDomain.CurrentDomain;
            currentDomain.UnhandledException += new UnhandledExceptionEventHandler(logUnhandledException);

            ServiceBase[] ServicesToRun;
            ServicesToRun = new ServiceBase[] 
			{ 
				new NagiosService()
			};
            appLog = ServicesToRun[0].EventLog;
            ServiceBase.Run(ServicesToRun);


        }

        static void logUnhandledException(object sender, UnhandledExceptionEventArgs args)
        {
            Exception e = (Exception)args.ExceptionObject;
            Console.WriteLine(e.Message + ":" + e.StackTrace);
            if (appLog != null)
            {
                appLog.WriteEntry("Fatal Error: " + e.Message + "\n" + e.StackTrace, EventLogEntryType.Error);
            }
        }
    }


}
