﻿using System;
using System.Collections.Generic;
using System.Text;
using Microsoft.EnterpriseManagement;
using Microsoft.EnterpriseManagement.Common;
using Microsoft.EnterpriseManagement.ConnectorFramework;

namespace NagiosService
{
    class Transformer
    {
        public NagiosAlert transform(ConnectorMonitoringAlert alert)
        {
            NagiosAlert rt = new NagiosAlert();
            //Defaultwert für Service setzen
            rt.Service = Properties.Settings.Default.NagiosSCOMService;
            string path = alert.MonitoringObjectPath;
            rt.Text = alert.Name;

            rt.State = 0;
            switch (alert.Severity)
            {
                case Microsoft.EnterpriseManagement.Configuration.ManagementPackAlertSeverity.Error:
                    rt.State = NagiosAlert.ERROR;
                    break;
                case Microsoft.EnterpriseManagement.Configuration.ManagementPackAlertSeverity.Warning:
                    rt.State = NagiosAlert.WARNING;
                    break;
                case Microsoft.EnterpriseManagement.Configuration.ManagementPackAlertSeverity.Information:
                    rt.State = NagiosAlert.OK; //ok
                    break;
                default:
                    rt.State = NagiosAlert.UNKNOWN; //unknown
                    break;
            }


            /* Beispielausgabe:
              #12 Alert received on 20.11.2008 14:08:45
>> Id: d6aaae7f-db19-4286-88da-035f3b0aa495
>> Category: Alert
>> ConnectorId: 038f2550-b6f3-11dd-bbcc-4ef555d89593
>> ConnectorStatus: Pending
>> RepeatCount: 1
>> ResolutionState: 0
>> LastModified: 20.11.2008 13:08:34
>> LastModifiedByNonConnector: 20.11.2008 13:08:02
>> Priority: Normal
>> Severity: Warning
>> Description: Module was unable to connect to namespace '\\w2kias1.w2ktest.fz
.de\ROOT\CIMV2'


This has happened 7 times since this instance was loaded.


HRESULT: 0x800706ba
Details: The RPC server is unavailable.



One or more workflows were affected by this.


Workflow name: System.Mom.BackwardCompatibility.Computer.Client.DiscoveryRule

Instance name: w2kias1.w2ktest.fzk.de

Instance ID: {274E3958-C23E-6C7A-C1C1-581E39A43A69}

Management group: diplomarbeit

*/
            Console.WriteLine("ObjectFullName: " + alert.MonitoringObjectFullName);
            Console.WriteLine("ObjectPath: " + alert.MonitoringObjectPath);
            Console.WriteLine("ObjectName: " + alert.MonitoringObjectName);
            Console.WriteLine("ResolutionState: " + alert.ResolutionState);
            //hostname auflösen
            if (path == null)
            {
                path = "";
            }

            if (path.Contains("\\"))
            {
                //sonderfall: Pfad ist mit \ getrennt
                path = path.Split(new char[] { '\\' })[0].ToLower();
            }
            else if (path.Contains(";"))
            {
                path = path.Split(new char[] { ';' })[0].ToLower();
            }

            if (path.Equals("") || path.Equals("microsoft.systemcenter.agentwatchersgroup"))
            {
                path = alert.MonitoringObjectFullName;
            }

            rt.Host = path;
            /*
             * http://www.scom2k7.com/opsmgr-2007-severity-and-resolution-state-values-for-alerts/
             * Resolution States
             * 0 = New
             * 255 = Closed
             * Severity Values for Alerts
             * 0 = INFORMATIONAL
             * 1 = WARNING
             * 2 = CRITICAL
             */
            if (alert.ResolutionState.ToString().Equals("255"))
            {
                //Sonderfall closed
                Console.WriteLine("Alert closed: " + alert.ResolutionState.ToString());
                rt.State = NagiosAlert.OK;
                rt.Text = Properties.Settings.Default.NagiosOKMessage;
            }


            //processing
            new Processor().process(alert, ref rt);
            return rt;
        }
    }
}
